//===============================================================================
// Microsoft patterns & practices Enterprise Library
// Configuration Application Block
//===============================================================================
// Copyright  Microsoft Corporation.  All rights reserved.
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY
// OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT
// LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE.
//===============================================================================

using System;
using System.Reflection;
using Microsoft.Practices.EnterpriseLibrary.Configuration.Factory;
using Microsoft.Practices.EnterpriseLibrary.Configuration.Properties;

namespace Microsoft.Practices.EnterpriseLibrary.Configuration.Injection
{
    /// <summary>
    /// Represents the base class from which all implementations of property parameter attributes must derive.
    /// </summary>
    /// <remarks>
    /// This attribute uses the property name to get the value through reflection for the paramter value.
    /// </remarks>
    [AttributeUsage(AttributeTargets.Property, AllowMultiple = false, Inherited = false)]
    public abstract class ConverterBaseAttribute : Attribute
    {
        /// <summary>
        /// Gets the <see cref="PropertyParameterFactory"/> used to create the parameter value.
        /// </summary>
        /// <param name="objectConfiguration">The object configuration used to retrieve the value.</param>
        /// <returns>A <see cref="PropertyParameterFactory"/> object.</returns>
        protected internal abstract IObjectFactory<TObjectToCreate, TObjectConfiguration> GetFactory<TObjectToCreate, TObjectConfiguration>(TObjectConfiguration objectConfiguration);
    }
}
